(*| 22:46 12/06/1990 *)
PROGRAM DIS6800;

{$DEFINE U6303}

USES Crt,StdTypes,DisUtils;

CONST
  MaxNewLineCode = 4;
  NewLineCodes : ARRAY[0..MaxNewLineCode] OF Integer =
   ($020,$039,$03B,$03F,$07E);

  Opcodes00 : ARRAY[0..$03F] OF OpCodeType =
   ('****','NOP ','****','****','LSRD','ASLD','TAP ','TPA ',
    'INX ','DEX ','CLV ','SEV ','CLC ','SEC ','CLI ','SEI ',

    'SBA ','CBA ','****','****','****','****','TAB ','TBA ',
    'XGDX','DAA ','SLP ','ABA ','****','****','****','****',

    'BRA ','BRN ','BHI ','BLS ','BCC ','BCS ','BNE ','BEQ ',
    'BVC ','BVS ','BPL ','BMI ','BGE ','BLT ','BGT ','BLE ',

    'TSX ','INS ','PULA','PULB','DES ','TXS ','PSHA','PSHB',
    'PULX','RTS ','ABX ','RTI ','PSHX','MUL ','WAI ','SWI ');

  Opcodes40 : ARRAY[0..$0F] OF OpCodeType =
   ('NEG ','AIM ','OIM ','COM ','LSR ','EIM ','ROR ','ASR ',
    'ASL ','ROL ','DEC ','TIM ','INC ','TST ','JMP ','CLR ');

  Opcodes80 : ARRAY[0..$0F] OF OpCodeType =
   ('SUBA','CMPA','SBCA','SUBD','ANDA','BITA','LDAA','STAA',
    'EORA','ADCA','ORAA','ADDA','CPX ','JSR ','LDS ','STS ');

  OpcodesC0 : ARRAY[0..$0F] OF OpCodeType =
   ('SUBB','CMPB','SBCB','ADDD','ANDB','BITB','LDAB','STAB',
    'EORB','ADCB','ORAB','ADDB','LDD ','STD ','LDX ','STX ');

  Opcode8D : OpCodeType = 'BSR ';

{$IFDEF U6303}
  MaxInvalidCode = 25;
{$ELSE}
  MaxInvalidCode = 58;
{$ENDIF}

  InvalidCodes : ARRAY[0..MaxInvalidCode] OF Integer =
   ($000,$002,$003,$012,$013,$014,$015,$01C,$01D,
{$IFNDEF U6303}
    $004,$005,$018,$01A,$021,$038,$03A,$03C,$03D,
    $061,$062,$065,$06B,$071,$072,$075,$07B,
    $083,$093,$09D,$0A3,$0B3,$0C3,$0CC,
    $0D3,$0DC,$0DD,
    $0E3,$0EC,$0ED,$0F3,$0FC,$0FD,
{$ENDIF}
    $01E,$01F,$041,$042,$045,
    $04B,$04E,$051,$052,$055,$05B,$05E,
    $087,$08F,
    $0C7,$0CD,$0CF);

FUNCTION BlankLineNeeded(OpCode: Byte): Boolean;
VAR
  I: Integer;
  B: Boolean;
BEGIN
  B:=False;
  FOR I:=0 TO MaxNewLineCode DO
    IF NewLineCodes[I]=OpCode THEN
      B:=True;
  BlankLineNeeded:=B;
END;  { BlankLineNeeded }

PROCEDURE SetMode80(OpCode: Byte);
BEGIN
  CASE OpCode AND $30 OF
    $00: BEGIN
           OpCodeAddressMode:=Immediate;
           IF (OpCode > $80) AND ((OpCode AND $3F) IN [$03,$0C,$0E]) THEN
             NumOfDataBytes:=2;
         END;
    $10: BEGIN
           OpCodeAddressMode:=Direct;
         END;
    $20: BEGIN
           OpCodeAddressMode:=Indexed;
           IF OpCode IN [$61,$62,$65,$6B] THEN
             NumOfDataBytes:=2;
         END;
    $30: BEGIN
           OpCodeAddressMode:=Extended;
           NumOfDataBytes:=2;
         END;
  END;
END;  { SetMode80 }

PROCEDURE ProcessData(Pass: Integer);
VAR
  ThisData:Word;
  I,DataBytes,BytesOnLine: Integer;
  InAscii,ExitLoop: Boolean;
BEGIN
  NeedBlankLine:=False;
  DataBytes:=1;
  IF NOT (Style IN [WordStyle,TableStyle]) THEN
    OpCodeString:='DB     '
  ELSE BEGIN
    OpCodeString:='DW     ';
    DataBytes:=2;
  END;
  BytesOnLine:=0;
  InAscii:=False;
  ExitLoop:=False;
  REPEAT
    ThisData:=0;
    FOR I:=1 TO DataBytes DO
      ThisData:=ThisData * 256 + GetNextByte;
    IF (Style=TableStyle) AND (Pass <> 2) THEN
      AddLabel(ThisData,Location);
    IF ((ThisData >= $20) AND (ThisData < $7B)) THEN BEGIN
      IF NOT InAscii THEN
        OpCodeString:=OpCodeString + #$27 + CHR(ThisData) + #$27 + ','
      ELSE BEGIN
        DELETE(OpCodeString,Length(OpCodeString)-1,2);
        OpCodeString:=OpCodeString + CHR(ThisData) + #$27 + ','
      END;
      InAscii:=True;
    END ELSE BEGIN
      OpCodeString:=OpCodeString + '$' + HexString(ThisData,2*DataBytes)
                                 + ',';
      InAscii:=False;
    END;
    INC(BytesOnLine);
    IF (BytesOnLine=ByteWidth) OR (CurrentAddress=SeqValue) THEN
      ExitLoop:=True;
    IF (Pass = 2) AND (CurrentAddress=NextLabelValue) THEN
      ExitLoop:=True;
  UNTIL ExitLoop;
  DELETE(OpCodeString,Length(OpCodeString),1);
END;

PROCEDURE ProcessOpCode(Pass:Integer);
VAR
  DataByte,ThisByte: Byte;
  ThisData,NewAddress: Word;
  I: Integer;
  AMC: String[5];
BEGIN
  ThisByte:=GetNextByte;
  IF NOT NeedBlankLine THEN
    NeedBlankLine:=BlankLineNeeded(ThisByte);
  OpCodeString:='';
  NumOfDataBytes:=1;
  OpCodeAddressMode:=Implied;
  FOR I := 0 TO MaxInvalidCode DO
    IF ThisByte = InvalidCodes[I] THEN BEGIN
      OpCodeString:='****';
      NumOfDataBytes:=0;
    END;
  IF Length(OpCodeString) = 0 THEN BEGIN
    IF ThisByte < $40 THEN BEGIN
      NumOfDataBytes:=0;
      OpCodeString:=Opcodes00[ThisByte];
      IF (ThisByte >= $20) AND (ThisByte < $30) THEN BEGIN
        NumOfDataBytes:=1;
        OpCodeAddressMode:=Relative;
      END;
    END ELSE IF ThisByte < $80 THEN BEGIN
      OpCodeString:=Opcodes40[ThisByte AND $0F];
      IF ThisByte < $50 THEN
        OpCodeString[4]:='A'
      ELSE BEGIN
        IF ThisByte < $60 THEN
          OpCodeString[4]:='B';
      END;
      IF ThisByte >= $60 THEN
        SetMode80(ThisByte)
      ELSE BEGIN
        OpCodeAddressMode:=Implied;
        NumOfDataBytes:=0;
      END;
    END ELSE IF ThisByte < $C0 THEN BEGIN
      IF ThisByte = $8D THEN BEGIN
        OpCodeString:=Opcode8D;
        OpCodeAddressMode:=Relative;
      END ELSE BEGIN
        OpCodeString:=Opcodes80[ThisByte AND $0F];
        SetMode80(ThisByte);
      END;
    END ELSE BEGIN
      OpCodeString:=OpcodesC0[ThisByte AND $0F];
      SetMode80(ThisByte);
    END;
  END;
  IF NumOfDataBytes > 0 THEN BEGIN
    ThisData:=0;
    FOR I:=1 TO NumOfDataBytes DO BEGIN
      DataByte:=GetNextByte;
      ThisData:=(ThisData SHL 8) + DataByte;
    END;
    IF (Pass <> 2) THEN BEGIN
      IF (ThisByte IN [$7E,$BD]) THEN
        AddLabel(ThisData,Location)
      ELSE IF (OpCodeAddressMode = Relative) THEN BEGIN
        IF DataByte AND $80 <> 0 THEN
          NewAddress:=CurrentAddress+ DataByte -$100
        ELSE
          NewAddress:=CurrentAddress+ DataByte;
        AddLabel(NewAddress,Location);
      END ELSE IF ((OpCodeAddressMode = Extended) OR
                   (ThisByte in [$8C,$8E,$CE,$DF])) THEN
        AddLabel(ThisData,ByteLabel)
      ELSE IF (OpCodeAddressMode = Direct) THEN
        AddLabel(ThisData,ByteLabel)
    END;
    IF Pass <> 1 THEN BEGIN
      AMC:='';
      CASE OpCodeAddressMode OF
        Immediate : AMC:='#$';
        Direct,
        Indexed,
        Extended  : AMC:='$';
      END;
      IF OpCodeAddressMode = Relative THEN BEGIN
        IF DataByte AND $80 <> 0 THEN
          NewAddress:=CurrentAddress+ DataByte -$100
        ELSE
          NewAddress:=CurrentAddress+ DataByte;
        AMC:='L' + HexString(NewAddress,4);
      END;
      OpCodeString:=OpCodeString + '  ' + AMC;
      IF OpCodeAddressMode <> Relative THEN
        OpCodeString:=OpCodeString + COPY(DataString,9,2*NumOfDataBytes);
      IF OpCodeAddressMode = Indexed THEN
        OpCodeString:=OpCodeString + ',X';
    END;
  END;
END;  { ProcessOpCode }

PROCEDURE ProcessFile(Pass:Integer);
VAR
  I: Integer;
  FirstByte: Byte;
  ThisLine: LineString;
  LineNum: Integer;
BEGIN
  Writeln('Pass ',Pass);
  IF Pass <> 2 THEN
    HiLabel:=1;
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN
      Writeln('':32,'ORG   $',HexString(StartAddress,4));
    IF SaveToDisk THEN
      Writeln(AsmFile,'':8,'ORG   $',HexString(StartAddress,4));
  END;
  Nextlabel:=1;
  NextLabelValue:=LongInt(Labels[1].Value);
  BufPtr:=ByteBuf;
  LineNum:=0;
  CurrentAddress:=StartAddress;
  EndOfByteFile:=False;
  NeedBlankLine:=False;
  Style:=CodeStyle;
  NextStyle:=CodeStyle;
  ByteWidth:=8;
  IF SeqExists THEN BEGIN
    Reset(SeqFile);
    NextSeq;
  END;
  REPEAT
    IF SeqExists AND (CurrentAddress >= SeqValue) THEN BEGIN
{                 AND (NOT EOF(SeqFile)) THEN BEGIN}
      DoBlankLine(LineNum);
      IF NextStyle = Remark THEN
        InsertRemark(LineNum)
      ELSE BEGIN
        Style:=NextStyle;
        ByteWidth:=NextByteWidth;
      END;
      NextSeq;
    END;
    IF Pass <> 1 THEN
      InsertLabel(LineNum);
    DataString:=HexString(CurrentAddress,4) + '  ';
    IF Style=CodeStyle THEN
      ProcessOpCode(Pass)
    ELSE
      ProcessData(Pass);
(*  IF Pass <> 2 THEN
      Writeln(DataString);*)
    IF Pass <> 1 THEN BEGIN
      ThisLine:=COPY(DataString + '        ',1,12) + '                    '
                                + OpCodeString;
      IF NOT QuietScreen THEN BEGIN
        Writeln(ThisLine);
        INC(LineNum);
      END;
      IF SaveToDisk THEN
        Writeln(AsmFile,'':8,OpCodeString);
      IF NeedBlankLine THEN BEGIN
        DoBlankLine(LineNum);
        NeedBlankLine:=False;
      END;
      IF LineNum > 20 THEN BEGIN
        IF NOT SaveToDisk THEN
          IF ReadKey=#$1B THEN BEGIN
            ShowLabels;
            HALT;
          END;
        LineNum:=0;
      END;
    END;
  UNTIL EndOfByteFile;
  IF Pass <> 2 THEN
    Writeln(HiLabel-1,' labels');
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN
      Writeln('':32,'END');
    IF SaveToDisk THEN
      Writeln(AsmFile,'':8,'END');
  END;
  Writeln;
END;  { ProcessFile }

BEGIN
  StartAddress:=$3000;
  IF ParamCount > 0 THEN
    ByteFileName:=ParamStr(1)
  ELSE
    ByteFileName:='D6800MOT.BIN';
  OpenSeqFile;
  Write('Disassembler by B Whitnall, V1.0, May 1990  ');
{$IFDEF U6303}
  Writeln('; 6303 ',ByteFileName);
{$ELSE}
  Writeln('; 6800 ',ByteFileName);
{$ENDIF}
  Writeln;
  Write('Save to Disk, Y/N ? ');
  SaveToDisk:=(UpCase(ReadKey)='Y');
  Writeln;
  QuietScreen:=False;
  IF SaveToDisk THEN BEGIN
    Write('Quiet Screen, Y/N ? ');
    QuietScreen:=(UpCase(ReadKey)='Y');
    Writeln;
  END;
  Writeln;
  ReadFileToBuf;
  IF ParamCount > 0 THEN
    StartAddress:=$10000 - ByteFileSize;
  EndAddress:=StartAddress + ByteFileSize;
  IF SaveToDisk THEN
    OpenAsmFile;
  FOR Pass:=1 TO 2 DO
    ProcessFile(Pass);
  IF SeqExists THEN
    Close(SeqFile);
  IF SaveToDisk THEN
    Close(AsmFile);
END.
